
--
global PxOpeningNewFile = false

-- save current Unit type to the property of the file; The function will be invoked before really saving a file
fn px_filePreSave = 
(
	--Do not stop simulation, Max may cause this event when baking.And users may save during simulation.
	if (not nvpx.IsSimulating()) do PxStopSimulation()
	
	PxSaveGlobalParams()

	-- set restore flag, bug #5247
	restorePose = nvpx.IsSimulating()
	physXpaneldata.restoreOriginalPose = restorePose
)


fn px_systemPreNew =
(
	PxStopSimulation()
)

fn px_filePreOpen =
(
	global PxRagdollList 
	PxStopSimulation()
	PxOpeningNewFile = true
	PxRagdollList = #()
)

fn PxScaleHelperSize scale = 
(
	--print scale
	
	for i in objects do
	(
		if classof(i) == nvConstraint then
		(
			i.helpersize = i.helpersize * scale
		)
	)
)

fn px_filePostOpen =
(
	global PxSetGlobalParamsFromPhysXPanelInterface

	-- remove broken RB modifiers
	PxDeleteBrokenRBs()
	
	PxOpeningNewFile = false

	-- clear items from previous scene
	nvpx.SwitchSDKOnPanelData()
	nvpx.RemoveAll()

	-- restore original pose if necessary, relative bug #5247
	PxLoadSavedPose()
	
	-- load parameters
	PxLoadFileProperties()
	PxSetGeometryScale(gPxGeometryScale)
	
	PxSetPhysXPanelInterfaceFromGlobalParams()
	PxRefreshPhysXToolPanel()
	
	--
	PxSolveCompatibilityIssues()
	
	-- reset parameters and gravity
	PxUpdatePhysXParameters()
	PxUpdateGravity()
	
	-- after SUS within file is loaded, 
	-- check if HelperSize of a JointVisualizer need to update
	curType = PxUnitTypeToEnum(units.SystemType)
	
	if px_plugin_unittype != curType then
	(
		pxType = PxUnitEnumToType(px_plugin_unittype)
		scale = PxSystemUnitChangeFactor pxType px_plugin_unitscale units.SystemType units.SystemScale
		PxScaleHelperSize scale
	)
	
	for i in objects do
	(
		if PxIsPhysicsObject(i) == false then
		(
			m = getUserProp i "LastPose"
			if m != undefined then
			(
				setUserProp i "LastPose" undefined
			)
		)
	)	

	-- show warning if trying to open a file created with later build
	PxCheckFileVersion()
)

fn px_systemPostNew =
(
	--format "px_systemPostNew\n"
	nvpx.RemoveAll()
	PxStopSimulation()

	PxInitGlobalParamsForNewFile()
	--PxLoadGlobalParams false
	PxLoadFileProperties()

	-- make contact distance as Rest Depth (skinWidth). US7668: Convert skin width for Rigid Body to Contact Shell style
	PxSetContactDistanceFromRestDepth()	
	PxSetPhysXPanelInterfaceFromGlobalParams()
	-- set the plugin version
	px_plugin_version = px_current_version
	
	-- clean undo buffer and system 'dirty' flag
	local old_save_required_val = getSaveRequired()
	setSaveRequired old_save_required_val

	--
	PxSetGeometryScale(gPxGeometryScale)
	
	-- reset parameters and gravity	
	PxUpdatePhysXParameters()
	PxUpdateGravity()
	
)

fn px_systemPreReset =
(
	--format "px_systemPreReset\n"
	PxStopSimulation()
	nvpx.RemoveAll()
)

fn px_systemPostReset =
(
	--format "px_systemPostReset\n"
	global PxRagdollList

	--PxLoadGlobalParams true
	PxResetGlobalParams()

	PxSetPhysXPanelInterfaceFromGlobalParams()
	-- reset parameters and gravity	
	PxUpdatePhysXParameters()
	PxUpdateGravity()
	PxRagdollList = #()
)

fn px_systemPreShutdown =
(
	PxStopSimulation()
	PxPanelClose()  -- close PhysX Tools Panel before nvpx.DestroyPhysX() to prevent crash
	nvpx.DestroyPhysX()
	if PHYSX_AUTODESK_VER == undefined then
	(
	
		-- clean UI: remove PhysX menu from the menu manager every time when MAX is shut down
		pxPhysXMenu = menuMan.findMenu nvpxText.TXT_WATCHER_MENUNAME_PHYSX
		if pxPhysXMenu != undefined do menuMan.unRegisterMenu pxPhysXMenu
	)
	
	-- delete old menu macros
	try(
		local targetMacroFiles = getFiles ((GetDir #userMacros) + "\\nvpx*.mcr")
		for i in targetMacroFiles do deleteFile i
		targetMacroFiles = getFiles ((GetDir #userMacros) + "\\nvidia*.mcr")
		for i in targetMacroFiles do deleteFile i
	) catch()
)

fn px_selectionChangedDirty =
(
	pxSelectionChangedDirty	 = true

	-- Update the tools panel if it's open, by triggering an immediate selection refresh
	if (px_physXPanel != undefined) and px_physXPanel.open then px_selectionChanged()
)

-- Update lists related to selected objects
fn px_UpdateSelectedRigidBodyLists =
(
	pxSelectionChangedDirty = false

	pxSelectedNodes = #()
	pxGroupNodes = #()
	pxSingleNodes = #()
	pxSelectedRigidBodyObjs = #()
	pxSelectedRigidBodyMods = #()
	pxSelectedHelpers = #()
	pxSelectedDummyHelpers = #()
	pxSelectedConstraints = #()
	pxCurrentNode = undefined
	pxCurrentNodeType = PX_PHYSTYPE_UNDEFINED
	
	pxCurrentNode = pxSelectionTool.parse $selection pxGroupNodes pxSingleNodes pxSelectedHelpers
	for i in pxSelectedHelpers do
	(
		local c = classof(i)
		if c == Dummy then append pxSelectedDummyHelpers i
		else if c == UConstraint then append pxSelectedConstraints i
	)
	
	for n in pxGroupNodes do (append pxSelectedNodes n)
	for n in pxSingleNodes do (append pxSelectedNodes n)

	for tempObj in pxSelectedNodes where ((tempMod) = (PxGetModRB tempObj)) != undefined do
	(
		append pxSelectedRigidBodyObjs tempObj
		append pxSelectedRigidBodyMods tempMod
	)	
	
	local sameType = true
	local type = PxGetNodeType pxCurrentNode
	for i in pxSelectedNodes do (if (PxGetNodeType i) != type then (sameType = false; exit))
	if sameType then pxCurrentNodeType = type	
)

fn px_selectionChanged =
(
	px_UpdateSelectedRigidBodyLists()

	-- Update the tools panel and multi-editor if open
	if (px_physXPanel != undefined) and px_physXPanel.open then px_physXPanel.refreshPage()
	
	--if  px_selectionChanged() != undefined then
	if pxCurrentNode != undefined then
	(
		if px_panel_rigidbody != undefined then px_panel_rigidbody.reload()

		-- get the first node's type
		local sameType = true
		type = PxGetNodeType pxCurrentNode
		for i in pxSelectedNodes do (if (PxGetNodeType i) != type then (sameType = false; exit))
		if sameType then pxCurrentNodeType = type
	)
)

selectionChangeFn = px_selectionChanged

fn PxUpdateModRBMassForGeometryChange =
(
	modRBArray = #()
	selectedNodesArray = PxGetSelectedNodes()
	for i in selectedNodesArray do (
		modRB = PxGetModRB i
		if modRB != undefined then
			appendIfUnique modRBArray modRB
	)
	for n in modRBArray do(
		n.volume = 0
		n.density = n.density  -- reset density to trigger updating mass
	)
)

fn PxMaxIsEditing =
(
	maxMode = toolmode.commandmode
	if maxMode == #uscale then true
	else if maxMode == #create then true
	else if maxMode == #move   then (
		if modPanel.getCurrentObject() != undefined then true
		else false
	)
	else false
)

fn px_stopSimulationForEditing =
(
	if PxMaxIsEditing() then 
	(
		PxStopSimulation()
		if modPanel.getCurrentObject() == undefined then PxUpdateModRBMassForGeometryChange()
	)
)

-- I tried some methods to detect geometry change. But none is proper for our application
--- we only want to be noticed by scale pivot and vertices changes.
--- 1. when geometry #(obj1, obj2) change id:#PhysX do (format "  node's geometry changed\n")
--- This will be raised when user moves/scales/edits vertices/rotates one node.
--- 2. NodeEventCallback mouseUp:true delay:500 geometryChanged:PxFindGeometryChange
--- It only works with 2008 and 2009
--- It only finds vertices changes. It can not find scale changes and pivot changes.
--- the nodes parameter

fn PxFindGeometryChange event nodes =
(
	PxStopSimulation()
	PxUpdateModRBMassForGeometryChange()
)

fn CallbackFn1 ev nd = (
	print ("Event Detected: Event "+(ev as string)+  ", Nodes " + (nd as string))
)


fn px_syncRagdollList = 
(
	global PxRagdollList
	t = callbacks.notificationParam();
	if  t!= undefined and classof(t) == RagdollHelper then
	(
		appendIfUnique  PxRagdollList t
	)
)

fn PxListenGeneralEvents =
(
	callbacks.removeScripts id:#PhysXPlugin
	
	-- register a callback notification before saving a scene
	callbacks.addScript #filePreSave "px_filePreSave()" id:#PhysXPlugin
	
	callbacks.addScript #filePreOpen "px_filePreOpen()" id:#PhysXPlugin
	callbacks.addScript #filePostOpen "px_filePostOpen()" id:#PhysXPlugin
	callbacks.addScript #systemPreNew "px_systemPreNew()" id:#PhysXPlugin
	callbacks.addScript #systemPostNew "px_systemPostNew()" id:#PhysXPlugin
	callbacks.addScript #systemPreReset  "px_systemPreReset()" id:#PhysXPlugin
	callbacks.addScript #systemPostReset  "px_systemPostReset()" id:#PhysXPlugin
	callbacks.addScript #preSystemShutdown "px_systemPreShutdown()" id:#PhysXPlugin
	
	callbacks.addScript #selectionSetChanged "px_selectionChangedDirty()" id:#PhysXPlugin
	
	callbacks.addScript #spacemodeChange   "px_stopSimulationForEditing()" id:#PhysXPlugin
	callbacks.addScript #preNodeGeneralPropChanged "px_stopSimulationForEditing()" id:#PhysXPlugin
	callbacks.addScript #preNodeBonePropChanged    "px_stopSimulationForEditing()" id:#PhysXPlugin
	callbacks.addScript #sceneNodeAdded "px_syncRagdollList()" id:#PhsyXPlugin
)

fn PxCheckOldVersionMenus =
(
	local oldMacroFiles1 = getFiles ((GetDir #userMacros) + "\\nvpx*.mcr")
	local oldMacroFiles2 = getFiles ((GetDir #userMacros) + "\\nvidia*.mcr")
	if (oldMacroFiles1.count > 0) or (oldMacroFiles2.count > 0) do
	(
		messagebox nvpxText.noticeRebootWhenOldMenu
	)
)

fn PxStartPlugin =
(
	nvpx.SetRBDisplayMaterial PxMatHullDynamicRB PxMatHullKinematicRB PxMatHullStaticRB
	
	--
	PxInitializePlugin()
	PxListenGeneralEvents()

	PxInitGlobalParamsForNewFile()
	--PxLoadGlobalParams true
	PxResetGlobalParams()

	PxSetPhysXPanelInterfaceFromGlobalParams()
	-- set version number
	px_plugin_version = px_current_version

	PxSetGeometryScale(gPxGeometryScale)

	if PHYSX_AUTODESK_VER == undefined then
	(
		global PxShowMainMenu
		PxShowMainMenu()
	)

	nvpxText.TXT_WATCHER_INFO
	
	-- reset parameters and gravity
	PxUpdatePhysXParameters()
	PxUpdateGravity()

	-- check old stuff. notice user to re-start 3ds Max. We clean them when quiting. see px_systemPreShutdown
	PxCheckOldVersionMenus()
)

-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEDUAFkMQxqI9PltZ2eUG16Ew
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTkwNjI1MDAwMDAwWhcNMjAwODA3MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBAMsptjSEm+HPve6+DClr+K4CgrtrONjtHxHBwTMC
-- mrwF9bnsdMiSgvYigTKk858TlqVs7GiBVLD3SaSZqfSXOv7L55i965L+wIx0EZxX
-- xDzbyLh1rLSSNWO8oTDIKnPsiwo5x7CHRUi/eAICOvLmz7Rzi+becd1j/JPNWe5t
-- vum0GL/8G4vYICrhCycizGIuv3QFqv0YPM75Pd2NP0V4W87XPeTrj+qQoRKMztJ4
-- WNDgLgT4LbMBIZyluU8iwXNyWQ8FC2ya3iJyy0EhZhAB2H7oMrAcV1VJJqwZcZQU
-- XMJTD+tuCqKqJ1ftv1f0JVW2AADnHgvaB6E6Y9yR/jnn4zECAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBADo7
-- 6cASiVbzkjsADk5MsC3++cj9EjWeiuq+zzKbe55p6jBNphsqLUvMw+Z9r2MpxTEs
-- c//MNUXidFsslWvWAUeOdtytNfhdyXfENX3baBPWHhW1zvbOPHQLyz8LmR1bNe9f
-- R1SLAezJaGzeuaY/Cog32Jh4qDyLSzx87tRUJI2Ro5BLA5+ELiY21SDZ7CP9ptbU
-- CDROdHY5jk/WeNh+3gLHeikJSM9/FPszQwVc9mjbVEW0PSl1cCLYEXu4T0o09ejX
-- NaQPg10POH7FequNcKw50L63feYRStDf6GlO4kNXKFHIy+LPdLaSdCQL2/oi3edV
-- MdpL4F7yw1zQBzShYMoxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQNQAWQxDGoj0+W1nZ5QbXoTANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQCdHYCZRjDwQFgpzc8ZX+Ap1YjzQYbgVfyX
-- MnW20P8oRVRAIxeHtjkm8NkpGLgaW8LVuMOB7X3IQtCP8Z5CuyLtmrm0VAv7kCFK
-- EeTJ1YABXizWh5JOUW4m+/ojn3fDcZ5lnCFnNWd9ZenW1OqNACRN0juiwO57vS8o
-- I+eTNPh3AvA7+9qXYP1yS88IkaHudw5C/TjcY8m5vnAP/mhjwaUhKBrRUWHet2DE
-- GFiQYvLExrnyUGR9OKgYVyRd1U2KxmmVgmUxc0ldV1ulzHyDFb8CuuqfZ1+AcmYP
-- vL5xtJgsgMV0JnaUMl3mJNyD4IHXmuIgLXayqE4tKpFOGZiqjgVQ
-- -----END-SIGNATURE-----